//
//  AFNetworkFunctions.h
//  Bonjour
//
//  Created by Keith Duncan on 02/01/2009.
//  Copyright 2009. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <sys/socket.h>

@class AFNetworkStream;

/*
	BSD Networking
 */

/*!
	\brief
	Read the port field from an Internet address family socket address.
	The port is converted into host byte order.
 */
extern uint16_t af_sockaddr_in_read_port(struct sockaddr_storage const *addr);
/*!
	\brief
	Write the port field to an Internet address familty socket address.
	The port is converted into network byte order.
 */
extern void af_sockaddr_in_write_port(struct sockaddr_storage *addr, uint16_t port);

/*!
	\brief
	
 */
extern bool af_sockaddr_compare(struct sockaddr_storage const *addr_a, struct sockaddr_storage const *addr_b);

/*!
	\brief
	Convert network form into presentation form.
 */
extern int af_sockaddr_ntop(struct sockaddr_storage const *addr, char *destination, size_t destinationSize);

/*!
	\brief
	Convert presentation form into machine form.
 */
extern int af_sockaddr_pton(char const *presentation, struct sockaddr_storage *storage);


/*
	Cocoa Networking
 */

/*!
	\brief
	Wrap `af_sockaddr_ntop()` with Cocoa level objects and error handling.
 */
extern NSString *AFNetworkSocketAddressToPresentation(NSData *socketAddress, NSError **errorRef);

/*!
	\brief
	This API is not lossy, you MAY convert the result back to a presentation format.
	Not all address families are supported.
	Wrap `af_sockaddr_pton()` with Cocoa level objects.
 */
extern NSData *AFNetworkSocketPresentationToAddress(NSString *presentation, NSError **errorRef);

/*!
	\brief
	It is highly unlikely that you will ever need to use this function.
	This function MUST NEVER be used to decide whether to attempt a connection, only to determine whether the cause of an error was due to reachability.
	This function SHOULD only be used where using CFNetworkIsConnectedToInternet() would be appropriate.
 */
extern BOOL AFNetworkIsConnectedToInternet(void);

/*!
	\brief
	Errors from AFNetworkStream are raw and unsuitable for display to the user, this function attempts to generate a legible error.
 */
extern NSError *AFNetworkStreamPrepareDisplayError(AFNetworkStream *stream, NSError *error);
